# Début programme de pilotage écran LCD16x2 RGB

# Fonctionne avec :
# Grove - LCD RGB Backlight
# Sciencethic 651 018

from time import sleep

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

# Nous importons la librairie de pilotage de l'afficheur LCD
# -> de cette librairie nous importons le seul élément LCD16x2RGB
from libLCD16x2RGB import LCD16x2RGB
# -> le fichier libLCD16x2RGB.py doit etre dans le meme répertoire que ce fichier de programme


################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uino Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-série Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)


# Instanciation d'un objet représentant l'afficheur LCD.
# La classe de cette objet effectue les différentes operations d'écriture I2C.
# Le constructeur de LCD16x2RGB prend en patametre l'objet qui représente la carte Plug'Uno
afficheurLCD = LCD16x2RGB(plugUno)

# Affichage d'une chaine de caractere a l'emplacement courrant du curseur d'écriture
afficheurLCD.print("Bonjour !")
# -> apres initialisation la position curseur est premiere colonne et premiere ligne

# Changer la couleur du retro-eclairage rouge,vert,bleu
# -> valeur 0~255
rouge = 255
vert = 255
bleu = 0
afficheurLCD.setColor( rouge , vert , bleu )

sleep(2)

# Définir la position du cuseur d'écriture
# -> première colonne et seconde ligne
afficheurLCD.setCursor(0,1)
afficheurLCD.print("Bonjour (ligne2)")

sleep(2)

# Effacer l'intégralité de l'ecran
afficheurLCD.clear()

# Mettre le curseur en position "home"
# -> premiere colonne et premiere ligne
afficheurLCD.home()

# Afficher ou non la position du curseur d'écriture
# True : affiché ; False : caché
afficheurLCD.cursor(True) 

# Activer le clignotement du curseur d'écriture
# True : clignotant ; False : fixe
afficheurLCD.blink(True)

# Compter de 0 a 49 en affichant la valeur
for i in range(50) :
    
    # Mettre le curseur en position "home"
    # -> premiere colonne et premiere ligne
    afficheurLCD.home()

    afficheurLCD.print("i : "+str(i))

    sleep(.1)

# Montrer les différentes nuances de Rouge
for i in range(255) :
    afficheurLCD.setColor( i , 0 , 0 )

# Montrer les différentes nuance de Vert
for i in range(255) :
    afficheurLCD.setColor( 0 , i , 0 )

# Montrer les différentes nuance de Bleu
for i in range(255) :
    afficheurLCD.setColor( 0 , 0 , i )


# Fermer la connexion à Plug'Uno avant de quitter.
plugUno.exit()

# Termine l'éxecution du programme Python.
# exit()
    
# Fin programme de pilotage écran LCD16x2 RGB





    





